<?php
namespace Base;

use Think\Auth;
use Admin\Model\AdminModel;

class AdminBaseController extends BaseController{
    
    /**
     * 当前登录管理员的ID
     * @var int
     */
    protected $_back_id;
    
    /**
     * 是否是最高管理员
     * @var int
     */
    protected $_is_top_manager;
    
    protected $baseModel = null;

    /**
     * 管理员信息数组
     * @var array
     */
    protected $_admin;
    
    protected function _initialize()
    {
    	$this->baseModel  = M();
    	
    	$this->_back_id = session('back_id');
    	
        //登录
        if(!$this->_back_id || $this->_back_id < 1){
           $this->redirect('Login/login');
        }
        
        // id是1的人是最高管理员
        if ($this->_back_id == 1) $this->_is_top_manager = 1;
        
        // 查询管理员信息
        $this->_admin = (new AdminModel())->where(array('id' => $this->_back_id))->find();
        
        
        $this->_check_admin();
        $this->_menuList();
    }
    
    protected function _menuList()
    {
        //获取登录用户
        $this->assign('login_admin',$this->_admin['name']);
        //获取用户组菜单
    }

    /**
     * 验证管理员
     */
    protected function _check_admin()
    {
        //超级管理员
        if($this->_is_top_manager == 1) return true;
        
        $response = array();
        
        if (empty($this->_admin) || $this->_admin['status'] == 0) {
            $this->error('没找到管理员信息或账户被禁用');
        }

        //验证权限
        $auth = new Auth();
        if(!$auth->check(MODULE_NAME.'/'.CONTROLLER_NAME.'/'.ACTION_NAME, $this->_back_id)){
            $this->error('对不起，没有权限！');
        }
    }
    
    //处理get参数
    protected function _getParams(){
    	foreach($_GET as $v){
    		if(preg_zh_str($v)){
    			$V = urldecode($v);
    		}
    	}
    	
    }
 
}
