<?php
namespace Base;
use Think\Controller;
use Think\Auth;

class BaseController extends Controller{
    public function __construct(){
        parent::__construct();
        // tettt
    }

     /**
     * 页码信息
     * @param unknown $curr_page
     * @param unknown $total_page
     */
    protected function _pager($curr_page, $total_page){
        $pager = array(
            'current_page' => $curr_page <= 0 ? 1 : $curr_page,
            'last_page'    => $curr_page - 1 <=0 ? '' : $curr_page - 1,
            'next_page'    => ($curr_page + 1 > $total_page) ? '' : $curr_page + 1,
            'total_pages'  => $total_page,
        );
        
        return $pager;
        
    }
    
 	protected function _empty(){
        if(IS_POST){
            $this->apiReturn(404);
        }else{
            $this->error($response['msg']);
        }
    }

    /**
     * 验证管理员
     */
    protected function _check_admin()
    {
        $response = array();
        
        if (empty($this->_admin) || $this->_admin['status'] == 0) {
            $response =401;
        }
        
        if (empty($response)) {
            //验证权限
            $auth = new Auth();
            if(!$auth->check(MODULE_NAME.'/'.CONTROLLER_NAME.'/'.ACTION_NAME, $this->_back_id)){
                $response = 402;
            }
        }
        
        if (!empty($response)) {
            //ajax请求
            if(IS_POST){
                $this->apiReturn($response);
            }else{
                $this->error($response['msg']);
            }
        }
    }

    //   /**
    //  * 验证管理员
    //  */
    // protected function _check_admin()
    // {
    //     $response = array();
        
    //     if (empty($this->_admin) || $this->_admin['status'] == 0) {
    //         $this->error('没找到管理员信息或账户被禁用');
    //     }
        
    //     //验证权限
    //     $auth = new Auth();
    //     if(!$auth->check(MODULE_NAME.'/'.CONTROLLER_NAME.'/'.ACTION_NAME, $this->_back_id)){
    //         $this->error('对不起，没有权限！');
    //     }
    // }

	/**
	* 设置事务标识
	* @param unknown $rst
	* @param unknown $is_commit
	* @return boolean
	*/
    protected function _setCommit($rst, $is_commit){
        return $rst && $is_commit;
    }
    
    /**
     * 开始事务
     */
    protected function _trans(){
        $this->baseModel->startTrans();
        return true;
    }
    
    /**
     * 事务提交或回滚
     * @param unknown $is_commit
     */
    protected function _commitOrRollback($is_commit){
        if($is_commit){
           return $this->_commit();
        }else{
            $this->_rollback();
            return false;
        }
    }
    
    /**
     * 提交事务
     */
    protected function _commit(){
       return $this->baseModel->commit();
    }
    
    /**
     * 回滚事务
     */
    protected function _rollback(){
        $this->baseModel->rollback();
        return false; // 添加数据失败
    }


    
}