<?php
namespace Frontend\Controller;

use Think\Controller;
use Common\Logic\Wechat\WechatWebApi;

class WxAuthorizeController extends Controller
{
    
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        session_start();
        // 授权成功后回到前端的地址
        $front_url = urlencode(trim('http://mallapp.guoguodz.com/test_h5/appwww/index.php'));
        if (!$this->checkFrontUrl($front_url)) $this->error('url参数不正确');
    
        // 获取code后返回的地址
        $redirect_uri = U('getUserInfo', '', true, true);
    
        $weChatApi = WechatWebApi::getInstance();
        $auth_url = $weChatApi->getOauthUrl($redirect_uri, 'snsapi_userinfo');
        
        redirect($auth_url);
    }
    
    public function getUserInfo()
    {
        session_start();
        $front_url = 'http://mallapp.guoguodz.com/test_h5/appwww/index.php';
        $code = trim(I('get.code', ''));
    
        if (empty($code)) $this->error('code参数错误');
    
        // 获取access token
        $weChatApi = WechatWebApi::getInstance();
        $token_data = $weChatApi->getOauthAccess($code);

        if (!$token_data) $this->error(var_export($weChatApi->getError(), true));
    
        // 获取微信用户信息
        $wei_user = $weChatApi->getUserInfo($token_data['access_token'], $token_data['openid']);
        if (!$wei_user) $this->error(var_export($weChatApi->getError(), true));
        $_SESSION["headimgurl"]=$wei_user['headimgurl'];
        $_SESSION["wx_name"]=$wei_user['nickname'];
        $url_query = array('open_id' => $user_info['open_id']);
        redirect($front_url);
    }
    
    protected function filterNickname($nickname)
    {
        $tmpStr = json_encode($nickname);
        $tmpStr = preg_replace("#(\\\ud[0-9a-f]{3})|(\\\ue[0-9a-f]{3})#ie","",$tmpStr);
        $tmpStr = json_decode($tmpStr);
        $tmpStr = str_replace('\'', '', $tmpStr);
        return trim($tmpStr);
    }
    
    /**
     * 把数组按照键值对拼进url的query部分
     *
     * @param string url
     * @param array $param
     * @return string
     */
    protected function parseFrontUrl($url, $param)
    {
        $front_url = '';
    
        $url_components = parse_url($url);
        $front_url .= $url_components['scheme'] . '://' . $url_components['host'];
        $front_url .= $url_components['port'] == '80' ? '' : ':' . $url_components['port'];
        $front_url .= $url_components['path'];
    
        parse_str($url_components['query'], $query_arr);
        $query_arr = $query_arr ? array_merge($query_arr, $param) : $param;
    
        $front_url .= !empty($query_arr) ? '?' . http_build_query($query_arr) : '';
        $front_url .= $url_components['fragment'] ? '#' . $url_components['fragment'] : '';
    
        return $front_url;
    }
    
    /**
     * 检查前端的URL，判断是否非本站
     * @param string $url
     * @return boolean 正确返回true，否则返回false
     */
    protected function checkFrontUrl($url)
    {
        if (empty($url)) return false;
        // @todo **原习斌**
        return true;
    }
}
