<?php
namespace Org\phpmailer;

class Mail {
    
    private $option = array();
    
    /*
     * 实例化时需要传入配置参数
     */
    public function __construct($config = array()) {
        $this->init($config);
    }

    public function init($config) {
        
        include_once('class.phpmailer.php');
        include_once('class.pop3.php');
        include_once('class.smtp.php');

        $this->option = array(
            'email_sendtype' => C('email_sendtype'),
            'email_host' => C('email_host'),
            'email_port' => C('email_port'),
            'email_ssl' => C('email_ssl'),
            'email_account' => C('email_account'),
            'email_password' => C('email_password'),
            'email_sender_name' => C('email_sender_name'),
            'email_sender_email' => C('email_sender_email'),
            'email_reply_account' => C('email_sender_email')
        );
        $this->option = array_merge($config, $this->option);
    }

    /**
     * 发送邮件
     * @param $sendto_email
     * @param $subject
     * @param $body
     * @param string $senderInfo
     * @param array|string $attachment 数组形式需要path(必需)和filename(可选)两个键;
     * 多文件需要是二维数组，单个文件可以以一维数组的形式；也可以仅传字符串形式的文件地址
     * @return bool
     */
    public function send_email($sendto_email, $subject, $body, $senderInfo = array(), $attachment = array()) {
        $mail = new \PHPMailer();
        if (!empty($attachment)) {
            if (!is_array($attachment)) {
                $mail->AddAttachment($attachment);
            }
            $path = ''; $filename = '';
            foreach($attachment as $value) {
                if (is_array($value)) {
                    if (array_key_exists('path', $value)) $path = $value['path']; else continue;
                    if (array_key_exists('filename', $value)) $filename = $value['filename'];
                    $mail->AddAttachment($path, $filename);
                } else {
                    if (array_key_exists('path', $attachment)) $path = $attachment['path']; else break;
                    if (array_key_exists('filename', $attachment)) $filename = $attachment['filename'];
                    $mail->AddAttachment($path, $filename);
                }
            }
        }

        if (empty($senderInfo)) {
            $sender_name = $this->option['email_sender_name'];
            $sender_email = $this->option['email_account'];
        } else {
            $sender_name = $senderInfo['email_sender_name'];
            $sender_email = $senderInfo['email_account'];
        }
        if ($this->option['email_sendtype'] == 'smtp') {
            $mail->Mailer = "smtp";
            $mail->Host = $this->option['email_host']; // sets GMAIL as the SMTP server
            $mail->Port = $this->option['email_port']; // set the SMTP port

            if ($this->option['email_ssl']) {
                $mail->SMTPSecure = "ssl"; // sets the prefix to the servier  tls,ssl
            }

            $mail->SMTPAuth = false;       // turn on SMTP authentication
            $mail->Username = $this->option['email_account'];  // SMTP username
            $mail->Password = $this->option['email_password']; // SMTP password
        }
        $mail->FromName = $sender_name;  // 发件人姓名
        $mail->From = $this->option['email_sender_email']; // 发件人邮箱
        $mail->CharSet = "UTF-8"; // 这里指定字符集！
        $mail->Encoding = "base64";

        if (is_array($sendto_email)) {
            foreach ($sendto_email as $v) {
                $mail->AddAddress($v);
            }
        } else {
            $mail->AddAddress($sendto_email);
        }
        //以HTML方式发送
        $mail->IsHTML(true); // send as HTML
        // 邮件主题
        $mail->Subject = $subject;
        // 邮件内容
        $mail->Body = $body;
        $mail->AltBody = "text/html";
        $mail->SMTPDebug = false;
        return $mail->Send();
    }

}
?>
