<?php
namespace Common\Logic\Wechat;

class Curl
{
    
    /**
     * curl资源
     * @var unknown
     */
    protected $ch;
    
    /**
     * 配置
     * @var array
     */
    protected $opt_arr = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => false,
        CURLOPT_NOSIGNAL => true
    );
    
    /**
     * curl_exec函数返回值
     * @var array
     */
    protected $result;
    
    /**
     * curl_getinfo函数返回值
     * @var array
     */
    protected $curl_info;
    
    public function __construct()
    {
        $this->_init();
    }
    
    /**
     * 设置配置信息
     * @param int 键
     * @param mixed 值
     * @return \Common\Logic\Wechat\Curl
     */
    public function setOpt($key, $val)
    {
        $this->opt_arr[$key] = $val;
        return $this;
    }
    
    /**
     * 设置url
     * @param string url
     * @return \Common\Logic\Wechat\Curl
     */
    public function setUrl($url)
    {
        return $this->setOpt(CURLOPT_URL, $url);
    }
    
    /**
     * 设置https请求
     * @return \Common\Logic\Wechat\Curl
     */
    public function setHttps()
    {
        return $this
        ->setOpt(CURLOPT_SSL_VERIFYPEER, false)
        ->setOpt(CURLOPT_SSL_VERIFYHOST, 2);
    }
    
    /**
     * 初始化
     * @throws \Exception
     */
    protected function _init()
    {
        $ch = curl_init();
        if (!$ch) throw new \Exception('初始化Curl错误');
        
        $this->ch = $ch;
    }
    
    /**
     * 设置请求方式为get
     * @return \Common\Logic\Wechat\Curl
     */
    public function setGet()
    {
        return $this->setOpt(CURLOPT_POST, false);
    }
    
    /**
     * 设置请求方式为post
     * @return \Common\Logic\Wechat\Curl
     */
    public function post()
    {
        return $this->setOpt(CURLOPT_POST, true);
    }
    
    /**
     * 发送请求
     */
    public function request()
    {
        curl_setopt_array($this->ch, $this->opt_arr);
        
        // 取得请求结果
        $this->result = curl_exec($this->ch);
        $error = curl_errno($this->ch);
        $this->curl_info = curl_getinfo($this->ch);
        
        if ($error > 0) throw new \Exception('Curl 错误：' . curl_strerror ($error) . '(' . $error . ')');
        
        return $this;
    }
    
    public function __get($att)
    {
        switch ($att) {
            case 'result':
            case 'curl_info':
                return $this->$att;
        }
        
        throw new \Exception($att . ' is not fund');
    }
}
