<?php

/**
 * 判断字符串是否包含中文
* @param unknown $zh_cn csj
* @return unknown
*/
function preg_zh_str($str){
    if(preg_match("/[\x7f-\xff]/",$str)){
        return true;
    }else{
        return false;
    }
}
/**
 * 匹配中文
* @param unknown $zh_cn
* @return unknown
*/
function preg_zh($zh_cn){
    preg_match("/^[\x{4e00}-\x{9fa5}]+$/u",$zh_cn, $result);
    return $result;
}

/**
 * 匹配银行卡号
 * @param unknown $bank_account
 * @return unknown
 */
function preg_bank_account($bank_account){
    $card = $bank_account;
    if (!is_numeric($card))
        return false;

    $card_len = strlen($card);
    $i = 0;
    $num_i = array();
    do{
        if (!$i){
            $num_x = $card_len % 2 ? 1 : 2;
        } else {
            $num_x = $num_x == 1 ? 2 : 1;
        }
        $num_i[$i] = (int)$card[$i] * $num_x;
        $num_i[$i] = $num_i[$i] > 9 ? $num_i[$i] - 9 : $num_i[$i];

    }while(isset($card[++$i]));
    $num_sum = array_sum($num_i);
    return $num_sum % 10 ? false : true;
}

/**
 * 匹配数字
 * @param unknown $number
 * @return unknown
 */
function preg_number($number){
    preg_match("/^[0-9]*$/", $number, $result);
    return $result;
}

/**
 匹配手机号码
 规则：
 手机号码基本格式：
 前面三位为：
 移动：134-139 147 150-152 157-159 182 187 188
 联通：130-132 155-156 185 186
 电信：133 153 180 189
 后面八位为：
 0-9位的数字
 */
function preg_phone($phone_num){
//     $rule  = "/^((13[0-9])|147|(15[0-35-9])|180|182|177|(18[5-9]))[0-9]{8}$/A";
    $rule = '#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^17[0,1,3,6,7,8]{1}\d{8}$|^18[\d]{9}$#';
    preg_match($rule,$phone_num,$result);
    return $result;
}

/**
 匹配身份证号
 规则：
 15位纯数字或者18位纯数字或者17位数字加一位x
 */
function preg_id_card($id_card_no){
    return verify_user_idcard_no($id_card_no);
}

function preg_email($email){
//     $rule ="/^[a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/";
//     preg_match($rule,$email,$result);
//     return $result;

    $result = filter_var($email, FILTER_VALIDATE_EMAIL);
    return $result;
}

/**
 * 验证用户身份证是否合法
 * @param unknown $id_card_no  身份证号
 * @return boolean
 */
function verify_user_idcard_no($id_card_no){
    $id_card_no = strtoupper($id_card_no);

    $rule = '/^(([0-9]{18})|([0-9]{17}X))$/';
    preg_match($rule,$id_card_no, $result);
    if(!$result)
       return false;
    
    $weight = array(7,9,10,5,8,4,2,1,6,3,7,9,10,5,8,4,2);           // 十七位数字
    $validate = array('1','0','X','9','8','7','6','5','4','3','2'); // mod11，对应校验码字符值

    $sum = 0;
    $last_id = substr($id_card_no, 17);
    for($i = 0; $i < 17; $i++){
        $id = $id_card_no{$i};
        $sum += $id * $weight[$i];
    }
    $val = $validate[$sum%11];
    return $last_id == $val;
}

/**
 * 匹配身份证的性别，0-未知，1-女，2-男
 * @param unknown $id_card_no
 * @return number
 */
function preg_id_card_sex($id_card_no){
    $sex = 0;
    if(!preg_id_card($id_card_no)) return $sex;
    $num = substr($id_card_no, 16,1);
    if($num % 2 == 0){
        $sex = 1; // 偶-女    奇-男
    }else{
        $sex = 2;
    }
    return $sex;    
}

