<?php
function get_ip(){
    static $realip;
    if (isset($_SERVER)){
        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])){
            $realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } else if (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $realip = $_SERVER["HTTP_CLIENT_IP"];
        } else {
            $realip = $_SERVER["REMOTE_ADDR"];
        }
    }else {
        if (getenv("HTTP_X_FORWARDED_FOR")){
            $realip = getenv("HTTP_X_FORWARDED_FOR");
        } else if (getenv("HTTP_CLIENT_IP")) {
            $realip = getenv("HTTP_CLIENT_IP");
        } else {
            $realip = getenv("REMOTE_ADDR");
        }
    }
    return $realip;
}

/**
 * 图片全路径
 * @param string $pic_path     数据库的路径
 * @param string param         路径参数
 * @param string which_cdn     采用那个cdn
 * @return string  返回文件路径
 * @author nk
 */
function pic_path($pic_path, $param = '', $which_cdn = 'qiniu'){
    $cdn_path = '';
    if(C('IS_USE_CDN')){
        switch ($which_cdn){
            case 'qiniu':
                $cdn_path = qiniu_cdn_path($pic_path, $param);
                break;
        }
        // 如果cdn 路径存在，即返回cdn路径
        if($cdn_path) return $cdn_path;
    }

    if(strpos($pic_path,'http://') === 0 || strpos($pic_path,'https://') === 0)
        return $pic_path;
        $domain = C('PIC_DOMAIN');
        $pic_path = ltrim(str_replace('\\', '/', $pic_path),'/');
        if($pic_path)
            return $domain.$pic_path;
            return '';
}

/**
 * 递归创建文件夹
 * @param unknown $dir
 * @return boolean
 */
function mkdirs($dir){
    return is_dir($dir) or (mkdirs(dirname($dir)) and mkdir($dir, 0777));
}
/**
 * [uploadActions 上传图片]
 * @param  [type] $name      [图片原名字]
 * @param  [type] $file_type [图片类型 goods/user/comment/theme/banner/city]
 * @param  string $value_id  [类型ID]
 * @param  string $filename  [单文件上传]
 * @param  string $filesize  [限制大小]
 * @return [type]            [array(array('file_name'=>'name','pic_path'=>'path'))]
 * @author [完颜不破] <[email address]>
 */
function uploadAction($name,$file_type,$value_id='',$filename='',$filesize='31457280') {
    if(!$value_id){
        return false;
    }
    $date = date('Ym',time());
    $date_path = './Uploads/'.$date.'/';

    $rootPath =$date_path.$file_type.'/'.$value_id.'/';

    mkdirs(rtrim($rootPath));
    $config = array(
        'maxSize'=>$filesize,
        'rootPath'=>$rootPath,
        'savePath'=>'',
        'saveName'=>array('uniqid',''),
        'exts'=>array('jpg', 'gif', 'png', 'jpeg','chm','pdf','zip','rar','tar','gz','bzip2'),
        'autoSub'=>true,
        'subName'=>false,
    );
    $upload =new \Think\Upload($config,'Local');
    if($filename){
        $info   =   $upload->upload_ad($filename);
    }else{
        $info   =   $upload->upload();
    }
    if(!$info){
        // return $upload->getError();
        return false;
    }else{
        foreach($info as $key=>$file){
            $file_path  = $config['rootPath'].$file['savepath'].$file['savename'];
            $file_path  = ltrim($file_path,'./');
            $path_arr[$key]['file_name'] = $name[$key];
            $path_arr[$key]['pic_path'] = $file_path;
            $path_arr[$key]['sort'] = $key+1;
        }
        return $path_arr;
    }
}
//excel导入图片方法
function getExtendFileName($file_name) {
    $extend = pathinfo($file_name);
    $extend = strtolower($extend["extension"]);
    return $extend;
}
function extractImageFromWorksheet($worksheet,$basePath){

    $result = array();

    $imageFileName = "";

    foreach ($worksheet->getDrawingCollection() as $drawing) {
        $xy=$drawing->getCoordinates();
        $path = $basePath;
        // for xlsx
        if ($drawing instanceof PHPExcel_Worksheet_Drawing) {

            $filename = $drawing->getPath();

            $imageFileName = $drawing->getIndexedFilename();

            $path = $path . $drawing->getIndexedFilename();

            copy($filename, $path);

            $result[$xy] = $path;

            // for xls
        } else if ($drawing instanceof PHPExcel_Worksheet_MemoryDrawing) {

            $image = $drawing->getImageResource();

            $renderingFunction = $drawing->getRenderingFunction();

            switch ($renderingFunction) {

                case PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG:

                    $imageFileName = $drawing->getIndexedFilename();
                    $path = $path . $drawing->getIndexedFilename();
                    imagejpeg($image, $path);
                    break;

                case PHPExcel_Worksheet_MemoryDrawing::RENDERING_GIF:
                    $imageFileName = $drawing->getIndexedFilename();
                    $path = $path . $drawing->getIndexedFilename();
                    imagegif($image, $path);
                    break;

                case PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG:
                    $imageFileName = $drawing->getIndexedFilename();
                    $path = $path . $drawing->getIndexedFilename();
                    imagegif($image, $path);
                    break;

                case PHPExcel_Worksheet_MemoryDrawing::RENDERING_DEFAULT:
                    $imageFileName = $drawing->getIndexedFilename();
                    $path = $path . $drawing->getIndexedFilename();
                    imagegif($image, $path);
                    break;
            }
            $result[$xy] = $imageFileName;
        }
    }

    return $result;
}

function add_water($path,$type=1,$width=0,$location=9){

    switch ($type) {
        case '1':
            $image = new \Think\Image();
            $water_path = $image->open($path)->water(C('WATER_LOGO'),$location,50)->save($path);
            return $water_path;
            break;
        case '2':
            $arr_path = explode('/',$path);
            array_pop($arr_path);
            $savepath = implode('/',$arr_path);
            $name = uniqid();
            $image->open($path);
            $type = $image->type();
            $thumb_path = $image->thumb($width, $width,\Think\Image::IMAGE_THUMB_SCALE)->save($savepath.'/suo'.$name.'.'.$type);
            return $thumb_path;
            break;
        case '3':
            $image = new \Think\Image();
            $water_path = $image->open($path)->water(C('WATER_LOGO'),$location,50)->save($path);

            $arr_path = explode('/',$path);
            array_pop($arr_path);
            $savepath = implode('/',$arr_path);
            $name = uniqid();
            $image->open($path);
            $type = $image->type();
            $thumb_path =$savepath.'/suo'.$name.'.'.$type;
            $res = $image->thumb($width, $width,\Think\Image::IMAGE_THUMB_SCALE)->save($thumb_path);
            return array('water'=>$water_path,'thumb'=>$thumb_path);
            break;
        default:
            # code...
            break;
    }

}